/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and may be covered by U.S. and Foreign Patents,
* patents in process, and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
*
**************************************************************************/


// ************************* API FUNCTIONS *******************************
function isDOMRequired()
{
  return false;
}

function canAcceptCommand(opt, context) 
{
	var dom = dw.getActiveWindow();
	if( !dom )
		return false;
	
	//we're in the visual aids menu, so if all visual aids are hidden, then we
	//should be disabled
	if( dom.getHideAllVisualAids() )
		return false;
	
	switch(opt)
	{
		case 'show_all':
		case 'show_columns':
		case 'show_box_outlines':
		case 'show_editor':
			switch( dw.getFocus() )
			{
				case 'document':
					return true;
					
				case 'textView':
					return (dom.getView() == 'split');
				
				case 'browser':
					return true;
			}
			break;
	}
	return false;
}

function receiveArguments(opt, context) 
{
	var dom = dw.getActiveWindow();
	if( !dom )
		return false;
	
	switch(opt)
	{
		case 'show_all':
			var hide = !dom.getHideCssLayoutColumns();
			dom.setHideCssLayoutColumns( hide );
			dom.setHideCssLayoutBoxes( hide );
			dom.setHideCssLayoutEditor( hide );	
			reloadOverlayDom(dom, hide);		
			break;
			
		case 'show_columns':
			dom.setHideCssLayoutColumns( !dom.getHideCssLayoutColumns() );
			break;
			
		case 'show_box_outlines':
			dom.setHideCssLayoutBoxes( !dom.getHideCssLayoutBoxes() );
			break;
		
		case 'show_editor':
			dom.setHideCssLayoutEditor( !dom.getHideCssLayoutEditor() );
			break;
	}
}

function reloadOverlayDom(dom, hide)
{
	if(hide)
	{
		var overlayBrowser = dom.getOverlayView('CssGrids.LayoutDivManipulator');
		if (overlayBrowser) 
		{
			var layoutDivManipulator = overlayBrowser.getWindow().layoutDivManipulator;
			if (layoutDivManipulator && layoutDivManipulator.shutdown)
			{
				layoutDivManipulator.shutdown();
			}
		}
						
		dom.unloadOverlayView('CssGrids.LayoutDivManipulator'); 
		return;
	}
	else
	{
		var overlayBrowser = dom.getOverlayView('CssGrids.LayoutDivManipulator');
				
		if (overlayBrowser) 
		{
			if( overlayBrowser.getWindow() )
			{
				var ldm = overlayBrowser.getWindow().layoutDivManipulator;
				if( ldm && !ldm.isInited() ) {
					ldm.init();
				}
			}
			return; // Already loaded.
		}

		overlayBrowser = dom.loadOverlayView('CssGrids.LayoutDivManipulator');	

		function createLayoutDivManipulator() 
		{
			var win = overlayBrowser.getWindow();
			// Attach these objects since they aren't attached automatically in webkit docs.
			win.dw = dw;
			win.dwscripts = dwscripts;
			win.DWfile = DWfile;
			win.overlayCtrl = overlayBrowser;
			overlayBrowser.getWindow().createLayoutDivManipulator(dom.URL); // Creates the LayoutDivManipulator JS object.
			overlayBrowser.removeEventListener('DocumentCompleted', createLayoutDivManipulator);
		}
		overlayBrowser.addEventListener('DocumentCompleted', createLayoutDivManipulator);
		var fileUrl = dw.getConfigurationPath() + '/Overlays/CssGrids/LayoutDivManipulator.htm';
		overlayBrowser.openURL(fileUrl);				
	}	
}

function isCommandChecked(opt, context)
{
	var dom = dw.getActiveWindow();
	if( !dom )
		return false;
	
	switch(opt)
	{
		case 'show_all':
				return (!dom.getHideCssLayoutColumns() && !dom.getHideCssLayoutBoxes() && !dom.getHideCssLayoutEditor());
				
		case 'show_columns':
			return !dom.getHideCssLayoutColumns();
		
		case 'show_box_outlines':
			return !dom.getHideCssLayoutBoxes();
		
		case 'show_editor':
			return !dom.getHideCssLayoutEditor();
	}
	
	return false;
}

function getMenuID(opt)
{
	return "";
}
